% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program: SynchronizationWithFrameRate.m

function SynchronizationWithFrameRate(pixelsPerFrame)
 
%% Display Setup Module
% Define display parameters
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2;	% from monitor calibration
p.ScreenBackground = 1;

% Open display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);
HideCursor;

vbl=Screen('Flip', windowPtr);

%% Experimental Module

% Specify the stimulus
p.barwidth = 10; % in pixels
if nargin < 1, pixelsPerFrame = p.barwidth; end 
        % shift barwidth pixels per frame
 
% Make a whole screen texture
img = ones(p.ScreenRect([4 3]));
tex = Screen('MakeTexture', windowPtr, img, 0, 0, 2);
 
offset = 0;
tEnd = vbl + 30;
 
% Show the moving bar
while vbl < tEnd
    Screen('DrawTexture', windowPtr, tex); 
    Screen('FillRect', windowPtr, 0, [offset 0 offset + ...
           p.barwidth p.ScreenRect(4)]);
    vbl = Screen('Flip', windowPtr);
    
    offset = offset + pixelsPerFrame;
    if offset + p.barwidth > p.ScreenRect(3), ...
       offset = 0; end
end 

%% System Reinstatement Module
Screen('CloseAll'); % close window and textures

